--------------------------------------------------------------------------------
-- filelist.lua                                                               --
-- 2012-02-29  - Pyriel                                                       --
--                                                                            --
--This is all filelist tables and related stuff.                              --
--                                                                            --
--------------------------------------------------------------------------------

--  Secondary list of file names/paths and their starting sectors on the target disc.
--  These are files that need to be patched with the listing of file LBAs and sizes.
--  The frompatch value indicates whether or not the file should be retrieved from
--  the patchdir above, instead of the source CD.
LBAPatchList = {
 { name="SLPM_861.68",     path="/",     startsector=0,   seekpos=0x7e10c },
 { name="VJ24.BIN",     path="/CDROM/100_ARJ/",     startsector=0,   seekpos=0x23f84 },
 { name="FURO.BIN",     path="/CDROM/140_HONP/",     startsector=0,   seekpos=0x16b9c },
 { name="HSOUND.BIN",     path="/CDROM/140_HONP/",     startsector=0,   seekpos=0x3c20 },
 { name="RBATTLE.BIN",     path="/CDROM/140_HONP/",     startsector=0,   seekpos=0x41dac },
 { name="SNDTEST.BIN",     path="/CDROM/140_HONP/",     startsector=0,   seekpos=0x27e7c },
 { name="IPRG_A3.BIN",     path="/CDROM/260_IKKI/",     startsector=0,   seekpos=0x114c8 },
 { name="IPRG_A4.BIN",     path="/CDROM/260_IKKI/",     startsector=0,   seekpos=0x11f18 },
 { name="IPRG_B2.BIN",     path="/CDROM/260_IKKI/",     startsector=0,   seekpos=0x10850 },
 { name="IPRG_D.BIN",     path="/CDROM/260_IKKI/",     startsector=0,   seekpos=0x10de4 },
 { name="IPRG_D2.BIN",     path="/CDROM/260_IKKI/",     startsector=0,   seekpos=0x10e08 },
 { name="IPRG_D3.BIN",     path="/CDROM/260_IKKI/",     startsector=0,   seekpos=0x11328 },
 { name="IPRG_J.BIN",     path="/CDROM/260_IKKI/",     startsector=0,   seekpos=0x10ca8 },
 { name="BOOT.BIN",     path="/CDROM/270_BOOT/",     startsector=0,   seekpos=0x236a4 },
 { name="ENDING.BIN",     path="/CDROM/270_BOOT/",     startsector=0,   seekpos=0x3d0c },
 { name="OVER.BIN",     path="/CDROM/270_BOOT/",     startsector=0,   seekpos=0xb9c4 },
 { name="STAFF.BIN",     path="/CDROM/270_BOOT/",     startsector=0,   seekpos=0x2fc0 },
}

function HasLBAList(name)
	local k, s;
	for k, s in ipairs(LBAPatchList) do
		if(s.name == name) then
			return true;
		end
	end
	return false;
end

--  This is a massive directory tree of the Suikoden II CD-ROM.
--  CD-Tool doesn't seem to allow you to enumerate the files/directories on a disc, and
--  I wanted to be able to order them by LBA which isn't something tools commonly provide.
--
--  By specification, Sony requires files and subdirectories of a particular directory node to
--  be contiguous on disc.  Suikoden II doesn't seek by path/file name, but playing it safe
--  and sticking to the spec seemed best.
--
--  The LBA and size of each file must be tracked in order to rebuild the
--  LBA listing stored in the game's main executable, and in sixteen other files.
--
--  Individual handling of files also makes it easier to patch them.  Just include the
--  file names in the PatchList above, and put the file in the patchdir.
FileList = {
 { name="SLPM_861.68",     path="/",     lba=0,   size=0 },
 { name="SYSTEM.CNF",     path="/",     lba=0,   size=0 },
 { name="BGM.XA",     path="/CDROM/",     lba=0,   size=0 },
 { name="A_1.VAB",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="A_2.VAB",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="BGM.SDD",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="BGM2.SDD",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="CYUTON.SDD",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="CYUUTON.SDD",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="KYARO.SDD",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="KYARO1.SDD",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="ROUYA.SDD",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="ROUYA.TKD",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="SEQ.SDD",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="SEQ2.SDD",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="STAY.VAB",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="STAY_B.VAB",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="STAY_C.VAB",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="STAY_D.VAB",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="STAY_E.VAB",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="STAY_F.VAB",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="STAY_G.VAB",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="STAY_H.VAB",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA01.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA02.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA03.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA04.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA05.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA06.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA07.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA08.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA09.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA10.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA11.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA12.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA13.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA14.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA15.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA16.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA17.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA18.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA19.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA20.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA21.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA22.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA23.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA24.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA25.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="VA26.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="WA.BIN",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="YAKUSO1.SDD",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="YAKUSO2.SDD",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="YAKUSO21.SDD",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="YAKUSO3.SDD",     path="/CDROM/010_ARA/",     lba=0,   size=0 },
 { name="B_1.VAB",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="B_3.VAB",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="DANGION.TKD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="ENHOKU1.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="ENHOK_CB.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="IKKI.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="KAISOU4.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="RYUBE1.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="RYUBE2.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="RYUBE3.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="RYUBE4.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="SD_B01.VAB",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="TOTO1.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="TOTO2.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="TOTO3.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="TOTO4.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="TOTO5.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB01.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB02.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB03.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB04.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB05.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB06.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB07.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB08.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB09.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB10.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB11.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB12.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB13.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB14.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB15.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB16.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB17.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB18.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB19.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB20.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VB21.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VIK1.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VIK2.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VIK3.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VIK4.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VIK5.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VIK6.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="VIK7.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="WB.BIN",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="YOUHEI.VAB",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="YUUWAKU.SDD",     path="/CDROM/020_ARB/",     lba=0,   size=0 },
 { name="C_1.VAB",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="C_4.VAB",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="C_5.VAB",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="FCEV_C.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="HAKUSHI1.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="HAKUSHI2.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="HAKUSHI3.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="HAKUSHI4.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="KOKKYO.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="KORONE.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE1_1.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE1_10.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE1_11.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE1_2.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE1_3.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE1_4.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE1_5.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE1_6.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE1_7.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE1_8.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE1_81.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE1_9.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE2_1.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE2_2.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE2_3.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE2_4.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE2_5.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE3.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE3_1.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="MUSE3_2.SDD",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="SD_C05.VAB",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC01.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC02.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC03.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC04.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC05.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC06.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC07.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC08.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC09.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC10.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC11.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC12.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC13.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC14.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC15.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC16.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC17.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC18.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC19.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC20.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC21.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC22.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC23.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC24.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC25.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC26.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC27.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC28.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC29.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC30.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="VC31.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="WC.BIN",     path="/CDROM/030_ARC/",     lba=0,   size=0 },
 { name="D_1.VAB",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="KAZE1.SDD",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="KAZE2.SDD",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="KUSU1.SDD",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="KUSUKUSU.SDD",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="NORTH1.SDD",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="NORTH2.SDD",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="NORTH3.SDD",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="NORTH4.SDD",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="NORTH5.SDD",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="NORTH6.SDD",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="RADATO1.SDD",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="RADATO2.SDD",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="RADATO3.SDD",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="RUKAMOR1.SDD",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="RUKAMOR2.SDD",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="RUKAMOR3.SDD",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="SD_D04.VAB",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="SOUTH1.SDD",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="SOUTH2.SDD",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="SOUTH3.SDD",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD01.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD02.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD03.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD04.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD05.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD06.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD07.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD08.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD09.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD10.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD11.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD12.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD13.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD14.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD15.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD16.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD17.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD18.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD19.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="VD20.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="WD.BIN",     path="/CDROM/040_ARD/",     lba=0,   size=0 },
 { name="E_1.VAB",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="E_2.VAB",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="E_3.VAB",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="E_4.VAB",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="E_5.VAB",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="E_6.VAB",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="GREEN1_1.SDD",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="GREEN1_2.SDD",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="GREEN1_3.SDD",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="GREEN1_4.SDD",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="GREEN1_5.SDD",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="GREEN1_6.SDD",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="GREEN1_7.SDD",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="GREEN1_8.SDD",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="GREEN1_9.SDD",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="GREEN2_1.SDD",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="GREEN2_2.SDD",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="GREEN2_3.SDD",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="GREEN2_4.SDD",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="GREEN2_5.SDD",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="GREEN2_6.SDD",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="GREEN2_7.SDD",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="MORIMURA.SDD",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="SEKISYO.SDD",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="VE01.BIN",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="VE02.BIN",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="VE03.BIN",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="VE04.BIN",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="VE05.BIN",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="VE06.BIN",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="VE07.BIN",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="VE08.BIN",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="VE09.BIN",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="VE10.BIN",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="VE11.BIN",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="VE12.BIN",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="VE13.BIN",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="VE14.BIN",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="VE15.BIN",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="VE16.BIN",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="VE17.BIN",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="WE.BIN",     path="/CDROM/050_ARE/",     lba=0,   size=0 },
 { name="BANAR.SDD",     path="/CDROM/060_ARF/",     lba=0,   size=0 },
 { name="BANAR2.SDD",     path="/CDROM/060_ARF/",     lba=0,   size=0 },
 { name="ROKKAKU.SDD",     path="/CDROM/060_ARF/",     lba=0,   size=0 },
 { name="TORAN1.SDD",     path="/CDROM/060_ARF/",     lba=0,   size=0 },
 { name="TORAN2.SDD",     path="/CDROM/060_ARF/",     lba=0,   size=0 },
 { name="VF01.BIN",     path="/CDROM/060_ARF/",     lba=0,   size=0 },
 { name="VF02.BIN",     path="/CDROM/060_ARF/",     lba=0,   size=0 },
 { name="VF03.BIN",     path="/CDROM/060_ARF/",     lba=0,   size=0 },
 { name="VF04.BIN",     path="/CDROM/060_ARF/",     lba=0,   size=0 },
 { name="VF05.BIN",     path="/CDROM/060_ARF/",     lba=0,   size=0 },
 { name="VF06.BIN",     path="/CDROM/060_ARF/",     lba=0,   size=0 },
 { name="VF07.BIN",     path="/CDROM/060_ARF/",     lba=0,   size=0 },
 { name="WF.BIN",     path="/CDROM/060_ARF/",     lba=0,   size=0 },
 { name="G_1.VAB",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="KITADO.SDD",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="KITADOUK.SDD",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="KOKOU.SDD",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="KUROMU1.SDD",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="KUROMU2.SDD",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="KUROMU3.SDD",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="KUROMU4.SDD",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="KUROMU5.SDD",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="RYUUKO.SDD",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="SD_G11.VAB",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="SOUTOU.SDD",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="TINTO1.SDD",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="TINTO2.SDD",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="TINTO21.SDD",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="TINTO3.SDD",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="TINTO4.SDD",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="TINTO5.SDD",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="TINTO6.SDD",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="TINTO7.SDD",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="TINTO8.SDD",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="VG01.BIN",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="VG02.BIN",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="VG03.BIN",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="VG04.BIN",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="VG05.BIN",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="VG06.BIN",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="VG07.BIN",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="VG08.BIN",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="VG09.BIN",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="VG10.BIN",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="VG11.BIN",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="VG12.BIN",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="VG13.BIN",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="VG14.BIN",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="VG15.BIN",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="VG16.BIN",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="VG17.BIN",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 --{ name="VG18.BIN",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="WG.BIN",     path="/CDROM/070_ARG/",     lba=0,   size=0 },
 { name="H_1.VAB",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="KOBORUT.SDD",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="LAKEWST1.SDD",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="TWORIV1.SDD",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="TWORIV2.SDD",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="TWORIV21.SDD",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="TWORIV3.SDD",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="TWORIV4.SDD",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="TWORIV5.SDD",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="VH01.BIN",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="VH02.BIN",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="VH03.BIN",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="VH04.BIN",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="VH05.BIN",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="VH06.BIN",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="VH07.BIN",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="VH08.BIN",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="VH09.BIN",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="VH10.BIN",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="VH11.BIN",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="VH12.BIN",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 --{ name="VH13.BIN",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 --{ name="VH14.BIN",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 --{ name="VH15.BIN",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 --{ name="VH16.BIN",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 --{ name="VH17.BIN",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="WH.BIN",     path="/CDROM/080_ARH/",     lba=0,   size=0 },
 { name="I_1.VAB",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="I_3.VAB",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="MATIMURA.SDD",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="MATIRU1.SDD",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="MATIRU2.SDD",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="MATIRU3.SDD",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="MATIRU4.SDD",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="MATIRU5.SDD",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="MATIRU6.SDD",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="MATIRU7.SDD",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="MATIRU8.SDD",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="MATIRU9.SDD",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="RAKUTEI.SDD",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="RAKUTEI2.SDD",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="VI01.BIN",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="VI02.BIN",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="VI03.BIN",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="VI04.BIN",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="VI05.BIN",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="VI06.BIN",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="VI07.BIN",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="VI08.BIN",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="VI09.BIN",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="VI10.BIN",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="VI11.BIN",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="VI12.BIN",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="VI13.BIN",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="VI14.BIN",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="VI15.BIN",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="WI.BIN",     path="/CDROM/090_ARI/",     lba=0,   size=0 },
 { name="ANSATU1.SDD",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="ANSATU2.SDD",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="HILAND1.SDD",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="HILAND2.SDD",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="HILAND3.SDD",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="HIMURA.SDD",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="JOUI1.SDD",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="J_2.VAB",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="J_3.VAB",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="LASTBOSS.SDD",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="RURUNO1.SDD",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="RURUNO2.SDD",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="RURUNO3.SDD",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="RURUNO4.SDD",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="RURUNO5.SDD",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="RURUNO6.SDD",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="RURUNO7.SDD",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="TAIKETU1.SDD",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ01.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ02.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ03.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ04.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ05.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ06.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ07.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ08.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ09.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ10.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ11.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ12.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ13.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ14.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ15.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ16.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ17.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ18.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ19.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ20.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ21.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ22.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ23.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="VJ24.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="WAHEI1.SDD",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="WJ.BIN",     path="/CDROM/100_ARJ/",     lba=0,   size=0 },
 { name="HONKYO1.SDD",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="HONKYO10.SDD",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="HONKYO2.SDD",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="HONKYO3.SDD",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="HONKYO4.SDD",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="HONKYO5.SDD",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="HONKYO6.SDD",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="HONKYO7.SDD",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="HONKYO8.SDD",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="HONKYO9.SDD",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="MINI1.SDD",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="MINI2.SDD",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="MINI3.SDD",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="MINI4.SDD",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="MINI5.SDD",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="MINI6.SDD",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="RYOURI.SDD",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="SD_K01.VAB",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="SD_K29.VAB",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="SD_MG1.VAB",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="SD_MG2.VAB",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="SD_MG3.VAB",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="SD_MG4.VAB",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="SD_MG5.VAB",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="SD_MG6.VAB",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="SD_MG7.VAB",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK01.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK02.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK03.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK04.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK05.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK06.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK07.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK08.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK09.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK10.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK11.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK12.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK13.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK14.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK15.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK16.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK17.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK18.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK19.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK20.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK21.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK22.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK23.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK24.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK25.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK26.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK27.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK28.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK29.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK30.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK31.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK32.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK33.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK34.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK35.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK36.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="VK37.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="WK.BIN",     path="/CDROM/110_ARK/",     lba=0,   size=0 },
 { name="ADA.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="AIR.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="AIR_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="ALX_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="AMD.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="AMD_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="ANI.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="APP_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="BIC.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="BOR.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="BOZ.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="CRY.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="CYK.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="CYK_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="ERI_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="FIC_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="FRE.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="FRE_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="FRI.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="FRI_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="FRK.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="FUT.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="GAB.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="GEN.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="GEO.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="GJM.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="GRE_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="GRI.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="HAN.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="HAW.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="HIC.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="HNF.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="JIJ.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="JO2.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="JOI.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="KAL.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="KAN.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="KAN_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="KIB_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="KKL.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="KKS.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="KLK.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="KMU.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="KNI.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="KRU_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="KSD.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="KSM.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="KSM_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="KYU.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="KYU_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="LFI.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="LKK.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="MCR.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="MCR_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="MDO.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="MFI.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="MI2.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="MIL.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="MRL_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="MSM.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="MTF.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="MTO.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="MTS.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="MTT.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="MUK.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="NAN.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="NAN_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="NIA.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="ORA.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="PEC.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="PR2_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="PRK_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="RIK.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="RKL.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="ROL.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="RYE.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="RYN.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="SEE.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="SEE_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="SEN.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="SHE.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="SHU.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="SIE.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="SIE_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="SIN.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="SIN_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="SIR.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="SMB.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="SNA.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="SRO.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="SSK.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="STA.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="STK.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="TAI.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="TAI_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="TEL_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="TEN.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="TOU.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="UNI.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="VAL.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="VAL_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="VAN.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="VIC.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="VIC_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="WIG.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="WOL.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="ZAI.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="ZAI_D.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="ZAM.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="ZKO.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="ZSH.BIN",     path="/CDROM/120_PLAY/",     lba=0,   size=0 },
 { name="DOUGUYA1.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="DOUGUYA2.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="KAJIYA1.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="KAJIYA2.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="KANTEIY1.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="KANTEIY2.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="KOUEKI1.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="KOUEKI2.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="KPARTY1.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="KPARTY2.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="MONSYOY1.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="MONSYOY2.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="PARTYIN1.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="PARTYIN2.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="SAVE1.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="SAVE2.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="UWASA1.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="UWASA2.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="YADOYA1.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="YADOYA2.BIN",     path="/CDROM/130_SHOP/",     lba=0,   size=0 },
 { name="BOOK.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="CHIE.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="CHIN.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="CHIN2.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="FISHING.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="FUDAZUK.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="FURO.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="F_DAT1.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="F_DAT2.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="F_DAT3.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="F_DAT4.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="F_DAT5.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="HDOUGUYA.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="HKAJIYA.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="HMAP.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="HMAP2.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="HMONSYOY.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="HSOUND.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="HWINDOW.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="KIKORI.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="MEYASU.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="MOGURA.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="ODORIKO.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="PARTYCE1.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="PARTYCH2.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="PARTYCHG.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="PEEPING.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="RBATTLE.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="RB_CHA00.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="RB_CHA01.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="RB_CHA02.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="RB_CHA03.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="RB_CHA04.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="RB_CHA05.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="RB_CHA06.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="RB_CHA07.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="RB_CHA08.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="RB_CHA09.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="RB_CHA10.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="REST.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="SHUGO.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="SNDTEST.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="SOUKO.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="STONE.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="SYUGOITM.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="TANTEI.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="TEAMCHG.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="TEAMCHG2.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="TELEPO.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="VB19PIN.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="VG08PIN.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="WAKEUP.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="WAKEUP2.BIN",     path="/CDROM/140_HONP/",     lba=0,   size=0 },
 { name="BP0_AFT.BIN",     path="/CDROM/150_BPRG/BUFF0/",     lba=0,   size=0 },
 { name="BP0_BEF.BIN",     path="/CDROM/150_BPRG/BUFF0/",     lba=0,   size=0 },
 { name="BP0_FST.BIN",     path="/CDROM/150_BPRG/BUFF0/",     lba=0,   size=0 },
 { name="BP0_MAK.BIN",     path="/CDROM/150_BPRG/BUFF0/",     lba=0,   size=0 },
 { name="BP0_SEC.BIN",     path="/CDROM/150_BPRG/BUFF0/",     lba=0,   size=0 },
 { name="BF_DAT.BIN",     path="/CDROM/160_BFDA/",     lba=0,   size=0 },
 { name="UD0_UN01.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN02.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN03.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN04.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN05.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN06.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN07.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN08.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN09.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN10.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN11.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN12.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN13.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN14.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN15.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN16.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN17.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN18.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN19.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN20.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN21.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN22.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN23.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN24.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN25.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN26.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN27.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN28.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN29.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN30.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN31.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN32.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN33.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN34.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN35.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN36.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN37.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN38.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN39.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN40.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN41.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN42.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN43.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN44.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN45.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN46.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN47.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN48.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN49.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN50.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="UD0_UN51.BIN",     path="/CDROM/170_UNIT/BUFF0/",     lba=0,   size=0 },
 { name="MAGIC.BAK",     path="/CDROM/180_MAGI/",     lba=0,   size=0 },
 { name="MAGIC.VAB",     path="/CDROM/180_MAGI/",     lba=0,   size=0 },
 { name="MD0_BLN1.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_BLN2.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_BLN3.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_BOR.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_BUR1.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_DAR1.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_DAR2.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_DAR3.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_DAR4.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_DAR5.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_DAR6.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_EAT1.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_EAT2.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_EAT3.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_EAT4.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_EAT5.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_FIR1.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_FIR2.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_FIR3.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_FIR4.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_FIR5.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_FUR.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_GAT1.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_GAT2.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_GAT3.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_GAT4.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_GRI1.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_GRI2.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_GRI3.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_HOL1.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_HOL2.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_HOL3.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_HOL4.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_KAE.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_KAL.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_KKS.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_KLK1.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_KLK2.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_KLK3.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_KSM.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_LFI.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_MDO.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_MFI.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_MIL.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_MSM.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_ORA.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_RAI.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SEN.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SHI1.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SHI2.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SHI3.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SHI4.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SIN.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SP1.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SP10.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SP3.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SP4.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SP5.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SP6.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SP7.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SP8.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SP9.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SUI.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SWO1.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SWO2.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SWO3.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SWO4.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_SYO.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_THU1.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_THU2.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_THU3.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_THU4.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_THU5.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_UNI1.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_UNI2.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_UNI3.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_VAL.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_WAT1.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_WAT2.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_WAT3.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_WAT4.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_WAT5.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_WIN1.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_WIN2.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_WIN3.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_WIN4.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_WIN5.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_WINR.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_WOL.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD0_ZAM.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC1.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC10.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC11.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC12.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC13.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC14.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC15.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC16.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC17.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC18.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC19.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC2.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC20.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC3.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC4.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC5.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC6.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC7.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC8.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MD_SPC9.BIN",     path="/CDROM/180_MAGI/BUFF0/",     lba=0,   size=0 },
 { name="MF_BOA0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_CIM0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_CIM1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_CIM2.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_COC0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_COC1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_COL0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_COL1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_DRE0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_DRE1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_DRE2.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_DRE3.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_DRE4.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_DRE5.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_DRE6.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_DRE7.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_DRE8.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_DRE9.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_DREA.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_DREB.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_DREC.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_DRED.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_EAR4.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_FIR1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_FIR3.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_FIR4.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_FIR5.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_GAR0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_GAR1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_GEK0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_GEK1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_GOL0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_GOL1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_GOR0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_GOR1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_GWO0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_GWO1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_HAP0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_HAP1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_IMO0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_IMO1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_IMO2.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_KI20.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_KI21.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_KUL0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_KUL1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_LAS0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_LAS1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_LAS2.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_LAS3.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_LAS4.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_LAS5.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_LAS6.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_LAS7.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_LUS0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_MAG0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_MAG1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_MAG2.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_MAG3.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_MAO0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_MAO1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_MEI0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_MEI1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_NEC0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_NEC1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_NED0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_NED1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_RAU0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_RAU1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_SAM0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_SEI0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_SEI1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_SID0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_SIE0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_SIE1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_SIR0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_TAR0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_TAR1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_UNI0.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_WIN1.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="MF_WIN3.BIN",     path="/CDROM/190_MEFE/",     lba=0,   size=0 },
 { name="METEO.STR",     path="/CDROM/200_MOV2/",     lba=0,   size=0 },
 { name="SWORD.STR",     path="/CDROM/200_MOV2/",     lba=0,   size=0 },
 { name="TATE.STR",     path="/CDROM/200_MOV2/",     lba=0,   size=0 },
 { name="THUNDER.STR",     path="/CDROM/200_MOV2/",     lba=0,   size=0 },
 { name="DOR.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="DOR_K.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="GOL.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="GOL_K.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="GOR.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="GWO1.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="GWO2.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="HAP1.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="HAP2.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="HAP_K.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="IMO1.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="IMO2.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="IMO3.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="KI1.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="KUL_SID.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="LAS.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="LUC1.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="LUC2.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="LUC3.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="LUS1.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="LUS2.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="LUS3.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="LUS4.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="LUS5.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="NEC1.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="NEC2.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="NEC3.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="NIK.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="NIK_K.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="RAT.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="RAT_K.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="RAU1.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="RAU2.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="RYO.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="RYO_K.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="SEI.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="SIE1.BIN",     path="/CDROM/210_BOSS/",     lba=0,   size=0 },
 { name="EFFECT.BIN",     path="/CDROM/220_EFFE/",     lba=0,   size=0 },
 { name="EB_VA05.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VB02.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VB02B.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VB02C.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VB07.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VB19.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VC07.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VC07B.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VC11.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VC16.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VC16B.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VC16C.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VD07.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VD07B.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VE01.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VE02.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VE03.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VE06.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VE08.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VE15.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VG01.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VG03.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VG04.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VG07.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VH01.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VH08.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EB_VJ04.BIN",     path="/CDROM/230_EVBA/",     lba=0,   size=0 },
 { name="EVEFFECT.BIN",     path="/CDROM/240_EVEN/",     lba=0,   size=0 },
 { name="FE_DAT00.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT01.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT02.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT03.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT04.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT05.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT06.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT07.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT08.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT09.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT10.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT11.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT12.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT13.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT14.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT15.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT16.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT17.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT18.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT19.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="FE_DAT20.BIN",     path="/CDROM/250_FEFE/",     lba=0,   size=0 },
 { name="IDAT_A3.BIN",     path="/CDROM/260_IKKI/",     lba=0,   size=0 },
 { name="IDAT_A4.BIN",     path="/CDROM/260_IKKI/",     lba=0,   size=0 },
 { name="IDAT_B2.BIN",     path="/CDROM/260_IKKI/",     lba=0,   size=0 },
 { name="IDAT_D.BIN",     path="/CDROM/260_IKKI/",     lba=0,   size=0 },
 { name="IDAT_D2.BIN",     path="/CDROM/260_IKKI/",     lba=0,   size=0 },
 { name="IDAT_D3.BIN",     path="/CDROM/260_IKKI/",     lba=0,   size=0 },
 { name="IDAT_J.BIN",     path="/CDROM/260_IKKI/",     lba=0,   size=0 },
 { name="IPRG_A3.BIN",     path="/CDROM/260_IKKI/",     lba=0,   size=0 },
 { name="IPRG_A4.BIN",     path="/CDROM/260_IKKI/",     lba=0,   size=0 },
 { name="IPRG_B2.BIN",     path="/CDROM/260_IKKI/",     lba=0,   size=0 },
 { name="IPRG_D.BIN",     path="/CDROM/260_IKKI/",     lba=0,   size=0 },
 { name="IPRG_D2.BIN",     path="/CDROM/260_IKKI/",     lba=0,   size=0 },
 { name="IPRG_D3.BIN",     path="/CDROM/260_IKKI/",     lba=0,   size=0 },
 { name="IPRG_J.BIN",     path="/CDROM/260_IKKI/",     lba=0,   size=0 },
 { name="BLOAD.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="BOOT.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="BOOTDAT.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="ENDING.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="ENDING1.SDD",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="ENDING2.SDD",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="END_DAT1.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="END_DAT2.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="END_DAT3.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="END_DAT4.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="END_DAT5.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="END_DAT6.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="EVENTDA1.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="EVENTDA2.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="EVENTDA3.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="EVENTDA4.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="EVENTDA5.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="EVENTDAT.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="G1LOAD.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 --{ name="KNMLOGO.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="OVER.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="STAFF.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="ST_END1.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="ST_END2.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="ST_END3.BIN",     path="/CDROM/270_BOOT/",     lba=0,   size=0 },
 { name="ALL.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="ARMS.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="ARMSD.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="ARMST.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="BOGU.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="CKD.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="DISH.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="DOGU.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="EMBL.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="EX_ITEM.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="FNAME.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="FNO.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="FOOD.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="GAME.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="KEVENT.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="KOTEI.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="MAGI.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="MS.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="NAME.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="PARTY.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="SUKI.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="TABLE.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="TOWN.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="TRADE.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="VARIA.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="WAR_DAT.BIN",     path="/CDROM/280_GAME/",     lba=0,   size=0 },
 { name="SD_WAR.BAK",     path="/CDROM/290_WAR/",     lba=0,   size=0 },
 { name="SD_WAR.VAB",     path="/CDROM/290_WAR/",     lba=0,   size=0 },
 { name="WAR_01.BIN",     path="/CDROM/290_WAR/",     lba=0,   size=0 },
 { name="WAR_02.BIN",     path="/CDROM/290_WAR/",     lba=0,   size=0 },
 { name="WAR_03.BIN",     path="/CDROM/290_WAR/",     lba=0,   size=0 },
 { name="WAR_04.BIN",     path="/CDROM/290_WAR/",     lba=0,   size=0 },
 { name="WAR_05.BIN",     path="/CDROM/290_WAR/",     lba=0,   size=0 },
 { name="WAR_06.BIN",     path="/CDROM/290_WAR/",     lba=0,   size=0 },
 { name="WAR_07.BIN",     path="/CDROM/290_WAR/",     lba=0,   size=0 },
 { name="WAR_08.BIN",     path="/CDROM/290_WAR/",     lba=0,   size=0 },
 { name="WAR_09.BIN",     path="/CDROM/290_WAR/",     lba=0,   size=0 },
 { name="WAR_10.BIN",     path="/CDROM/290_WAR/",     lba=0,   size=0 },
 { name="WAR_11.BIN",     path="/CDROM/290_WAR/",     lba=0,   size=0 },
 { name="WAR_12.BIN",     path="/CDROM/290_WAR/",     lba=0,   size=0 },
 { name="WAR_13.BIN",     path="/CDROM/290_WAR/",     lba=0,   size=0 },
 { name="WAR_14.BIN",     path="/CDROM/290_WAR/",     lba=0,   size=0 },
 { name="WAR_15.BIN",     path="/CDROM/290_WAR/",     lba=0,   size=0 },
 { name="WAR_16.BIN",     path="/CDROM/290_WAR/",     lba=0,   size=0 },
 { name="BOSS0.STR",     path="/CDROM/300_MOVI/",     lba=0,   size=0 },
 { name="BOSS1.STR",     path="/CDROM/300_MOVI/",     lba=0,   size=0 },
 { name="BOSS2.STR",     path="/CDROM/300_MOVI/",     lba=0,   size=0 },
 { name="DEMO1.STR",     path="/CDROM/300_MOVI/",     lba=0,   size=0 },
 { name="DEMO2.STR",     path="/CDROM/300_MOVI/",     lba=0,   size=0 },
 { name="DEMO3.STR",     path="/CDROM/300_MOVI/",     lba=0,   size=0 },
 { name="DEMO5.STR",     path="/CDROM/300_MOVI/",     lba=0,   size=0 },
 { name="DEMO6.STR",     path="/CDROM/300_MOVI/",     lba=0,   size=0 },
 { name="KONA5OLD.STR",     path="/CDROM/300_MOVI/",     lba=0,   size=0 },
 { name="KONAMIC5.STR",     path="/CDROM/300_MOVI/",     lba=0,   size=0 },
 { name="LOOP.STR",     path="/CDROM/300_MOVI/",     lba=0,   size=0 },
 { name="OP0731.STR",     path="/CDROM/300_MOVI/",     lba=0,   size=0 },
 { name="ROCK.STR",     path="/CDROM/300_MOVI/",     lba=0,   size=0 },
 { name="_KONAMIC.STR",     path="/CDROM/300_MOVI/",     lba=0,   size=0 },
 { name="YYY.STR",     path="/",     lba=0,   size=0 },
 { name="ZZZ.STR",     path="/",     lba=0,   size=0 },
}
